function mfs_exp_vect2(fid, cmp, vect, title)

# usage: mfs_exp_vect(fid, cmp, vect, title)
#
# Input  fid            File handle of output file
#        cmp            Structure with component
#        vect(:)        Structure with vector data
#        title{:, 2}    Cell array with view names (translations,
#                                                   rotations
#
# The functions exports two vectors in Gmsh MSH file format. The first
# vector corresponds to translational and the second to rotational
# degrees of freedom.
#
# ------------------------------------------------------------------------

  zero = 0.;
  zvec = [0., 0., 0., 0., 0., 0.];

# Get parameters needed

  nlc      = length(vect);
  ncoor    = cmp.nodes.ncoor;
  mxdofpnt = cmp.dofs.mxdofpnt;
  nofnod   = cmp.nodes.nofnod;

# Define function to write the vectors

  if (ncoor == 2)
     prtt = @(id, v) fprintf(fid, "%-5d %-10.3e %-10.3e 0.0\n", id, v);
     prtr = @(id, v) fprintf(fid, "%-5d 0.0 0.0 %-10.3e\n", id, v);
     ct  = 1 : 2;
     cr  = 3;
     rot = mxdofpnt == 3;
  else
     prtt = @(id, v) fprintf(fid, "%-5d %-10.3e %-10.3e %-10.3e\n", id, v);
     prtr = @(id, v) fprintf(fid, "%-5d %-10.3e %-10.3e %-10.3e\n", id, v);
     ct  = 1 : 3;
     cr  = 4 : 6;
     rot = mxdofpnt == 6;
  end

# Loop over loadcases

  for l = 1 : nlc

#     Translations: Header

      fprintf(fid, "$NodeData\n");

#     Translations: Tags

      nofvec = vect(l).nofnod;
      n      = 1;
      k      = 1;

      fprintf(fid, "1\n""%s""\n", title{l, 1});
      fprintf(fid, "1\n%-10.3f\n", zero);
      fprintf(fid, "3\n%-3d\n3\n%-5d\n", 0, nofnod);

#     Translations: Data

      while (k <= nofvec && n <= nofnod)
          id = cmp.nodes.ids(n);
          if (n++ == vect(l).id(k));
             v  = vect(l).d(k++, ct);
             prtt(id, v);
          else
             prtt(id, zvec(ct));
          end
      end
      for k = n : nofnod
          prtt(cmp.nodes.ids(k), zvec(ct));
      end

#     Translations: End

      fprintf(fid, "$EndNodeData\n");

      if (rot)

#     Rotations: Header

         fprintf(fid, "$NodeData\n");

#     Rotations: Tags

         nofvec = vect(l).nofnod;
         n      = 1;
         k      = 1;

         fprintf(fid, "1\n""%s""\n", title{l, 2});
         fprintf(fid, "1\n%-10.3f\n", zero);
         fprintf(fid, "3\n%-3d\n3\n%-5d\n", 0, nofnod);

#     Rotations: Data

         while (k <= nofvec && n <= nofnod)
             id = cmp.nodes.ids(n);
             if (n++ == vect(l).id(k));
                v  = vect(l).d(k++, cr);
                prtr(id, v);
             else
                prtr(id, zvec(cr));
             end
         end
         for k = n : nofnod
             prtr(cmp.nodes.ids(k), zvec(cr));
         end

#     End

         fprintf(fid, "$EndNodeData\n");

      end

  end   % Loadcase loop

end
