function mfs_exp_cdisp(fid, cmp, dsp, title)

# usage: mfs_exp_cdisp(fid, cmp, dsp, title)
#
# Input  fid         File handle of output file
#        cmp         Structure with component
#        disp(:, :)  Displacements
#        title(:)    Cell array with view names
#
# The function exports complex displacements in Gmsh MSH file format vers.
# 4.1. The real part is written as time step 0 and the imaginary part as
# time step 1.
#
# ------------------------------------------------------------------------

  zero = 0.;

# Get parameters needed

  nofnod   = cmp.nodes.nofnod;
  mxdofpnt = cmp.dofs.mxdofpnt;
  nlc      = columns(dsp);

# Define parameters to write the displacements

  if (cmp.nodes.ncoor == 2)
     ixc = 1 : 2;
     len = 3;
     fmt = "%d %e %e 0.0\n";
  else
     ixc = 1 : 3;
     len = 4;
     fmt = "%d %e %e %e\n";
  endif

# Loop over loadcases

  for l = 1 : nlc

      u = reshape(dsp(:, l), mxdofpnt, nofnod);

#     Real Part

      fprintf(fid, "$NodeData\n");

      fprintf(fid, "1\n\"%s\"\n", title{l});
      fprintf(fid, "1\n%3f\n", zero);
      fprintf(fid, "3\n%d\n3\n%d\n", 0, nofnod);

      values = [cmp.nodes.ids; real(u(ixc, :))];
      fprintf(fid, fmt, values);

      fprintf(fid, "$EndNodeData\n");

#     Imaginary Part

      fprintf(fid, "$NodeData\n");

      fprintf(fid, "1\n\"%s\"\n", title{l});
      fprintf(fid, "1\n%3f\n", zero);
      fprintf(fid, "3\n%d\n3\n%d\n", 1, nofnod);

      values(2 : len, :) = imag(u(ixc, :));
      fprintf(fid, fmt, values);

      fprintf(fid, "$EndNodeData\n");

  endfor

endfunction
