function mfs_exp_disp(fid, cmp, dsp, title)

# usage: mfs_exp_disp(fid, cmp, dsp, title)
#
# Input  fid         File handle of output file
#        cmp         Structure with component
#        dsp(:, :)   Displacements
#        title(:)    Cell array with view names
#
# The function exports displacements in Gmsh MSH file format vers. 4.1.
#
# ------------------------------------------------------------------------

  zero = 0.;

# Get parameters needed

  nofnod   = cmp.nodes.nofnod;
  mxdofpnt = cmp.dofs.mxdofpnt;
  nlc      = columns(dsp);

# Define parameters to write the displacements

  if (cmp.nodes.ncoor == 2)
     ixc = 1 : 2;
     len = 3;
     fmt = "%d %e %e 0.0\n";
  else
     ixc = 1 : 3;
     len = 4;
     fmt = "%d %e %e %e\n";
  endif

# Loop over loadcases

  for l = 1 : nlc

#     Header

      fprintf(fid, "$NodeData\n");

#     Tags

      fprintf(fid, "1\n\"%s\"\n", title{l});
      fprintf(fid, "1\n%f\n", zero);
      fprintf(fid, "3\n%d\n3\n%d\n", 0, nofnod);

#     Data

      u      = reshape(dsp(:, l), mxdofpnt, nofnod);
      values = [cmp.nodes.ids; u(ixc, :)];
      fprintf(fid, fmt, values);

#     End

      fprintf(fid, "$EndNodeData\n");

  endfor

endfunction
