function mfs_exp_mesh(fid, cmp)

# usage: mfs_exp_mesh(fid, cmp)
#
# Input  fid     File handle of output file
#        cmp     Structure with component
#
# This function exports the mesh in Gmsh MSH file format version 4.1.
#
# ------------------------------------------------------------------------

# Check arguments

  if (nargin != 2)
     print_usage();
  endif

# Build table to get element dimension from element type index

  typ2dim = gmshid2dim(cmp.elements.types, cmp.elements.noftyp);

# Build Physical Names from node and element sets

 [set2phys, eset] = mfs_exp_phys(fid, cmp, typ2dim);   

# Build Entities

  [nodx, eltx] = mfs_exp_entities(fid, cmp, set2phys, typ2dim, eset);

# Output nodal points

  mfs_exp_nodes(fid, nodx);

# Output elements

  mfs_exp_elts(fid, eltx);

endfunction

function typ2dim = gmshid2dim(types, noftyp)

# usage: typ2dim = gmshid2dim(types, noftyp)
#
# Input  types(noftyp)   Structure array types from structure elements
#        noftyp          Number of element types
#
# Output typ2dim(noftyp) Element dimensions
#
# ------------------------------------------------------------------------

  % elmentType, Dimension (must be sorted according to elementType)

  elist = [  1, 1;      % 2-node line
             2, 2;      % 3-node triangle
             3, 2;      % 4-node quadrangle
             4, 3;      % 4-node tetrahedron
             5, 3;      % 8-node hexahedron
             6, 3;      % 6-node prism
             9, 2;      % 6-node triangle
            10, 2;      % 9-node quadrangle
            11, 3;      % 10-node tetrahedron
            12, 3;      % 27-node hexahedron
            13, 3;      % 18-node prism 
            15, 0;      % 1-node point
            16, 2;      % 8-node quadrangle
            17, 3;      % 20-node hexahedron
            18, 3];     % 15-node prism

  gmshid = [types.gmshid];
  eindx  = lookup(elist(:, 1), gmshid, "m");

  undef = find(eindx == 0);
  if (length(undef) != 0)
     error("mfs_exp_phys > gmshid2dim: elementType %d not in elist\n",
           gmshid(undef));
  end

  typ2dim = elist(eindx, 2);

endfunction
