function mfs_exp_rot(fid, cmp, dsp, title)

# usage: mfs_exp_rot(fid, cmp, dsp, title)
#
# Input  fid         File handle of output file
#        cmp         Structure with component
#        dsp(:, :)   Displacements
#        title(:)    Cell array with view names
#
# The function exports rotations in Gmsh MSH file format vers. 4.1.
#
# ------------------------------------------------------------------------

  zero = 0.;

# Get parameters needed

  nofnod   = cmp.nodes.nofnod;
  mxdofpnt = cmp.dofs.mxdofpnt;
  nlc      = columns(dsp);

# Check if there are rotations

  if (mxdofpnt == cmp.nodes.ncoor) return; endif

# Define parameters to write the rotations

  if (cmp.nodes.ncoor == 2)
     ixc = 3;
     len = 2;
     fmt = "%d 0.0 0.0 %e\n";
  else
     ixc = 4 : 6;
     len = 4;
     fmt = "%d %e %e %e\n";
  endif

# Loop over loadcases

  for l = 1 : nlc

#     Header

      fprintf(fid, "$NodeData\n");

#     Tags

      fprintf(fid, "1\n\"%s\"\n", title{l});
      fprintf(fid, "1\n%f\n", zero);
      fprintf(fid, "3\n%d\n3\n%d\n", 0, nofnod);

#     Data

      u      = reshape(dsp(:, l), mxdofpnt, nofnod);
      values = [cmp.nodes.ids; u(ixc, :)];
      fprintf(fid, fmt, values);

#     End

      fprintf(fid, "$EndNodeData\n");

  endfor

endfunction
