function mfs_exp_tdisp(fid, cmp, dsp, t, title)

# usage: mfs_exp_tdisp(fid, cmp, dsp, t, title)
#
# Input  fid         File handle of output file
#        cmp         Structure with component
#        dsp(:, :)   Displacements
#        t(:)        Time steps
#        title       View name
#
# The function exports time-dependent displacements in Gmsh MSH file
# format vers. 4.1.
#
# ------------------------------------------------------------------------

  zero = 0.;

# Get parameters needed

  nofnod   = cmp.nodes.nofnod;
  mxdofpnt = cmp.dofs.mxdofpnt;
  nt       = columns(dsp);

# Define format to write the displacements

  if (cmp.nodes.ncoor == 2)
     ixc = 1 : 2;
     len = 3;
     fmt = "%d %e %e 0.0\n";
  else
     ixc = 1 : 3;
     len = 4;
     fmt = "%d %e %e %e\n";
  endif

# Loop over time steps

  for l = 1 : nt

#     Header

      fprintf(fid, "$NodeData\n");

#     Tags

      fprintf(fid, "1\n\"%s\"\n", title);
      fprintf(fid, "1\n%e\n", t(l));
      fprintf(fid, "3\n%d\n3\n%d\n", l - 1, nofnod);

#     Data

      u      = reshape(dsp(:, l), mxdofpnt, nofnod);
      values = [cmp.nodes.ids; u(ixc, :)];
      fprintf(fid, fmt, values);

#     End

      fprintf(fid, "$EndNodeData\n");

  endfor

endfunction
