function mfs_exp_vect2(fid, cmp, vect, title)

# usage: mfs_exp_vect(fid, cmp, vect, title)
#
# Input  fid            File handle of output file
#        cmp            Structure with component
#        vect(:)        Structure with vector data
#        title{:, 2}    Cell array with view names (translations,
#                                                   rotations
#
# The functions exports two vectors in Gmsh MSH file format vers. 4.1. The
# first vector corresponds to translational and the second to rotational
# degrees of freedom.
#
# Fields of structure vect that are used:
#   nofnod               number of nodal points with data
#   id(nofnod)           indices of nodal points with data
#   d(nofnod, mxdofpnt)  data
#
# ------------------------------------------------------------------------

  zero = 0.;
  zvec = [0., 0., 0., 0., 0., 0.];

# Get parameters needed

  nlc      = length(vect);
  mxdofpnt = cmp.dofs.mxdofpnt;
  nofnod   = cmp.nodes.nofnod;

# Define parameters to write the vectors

  if (cmp.nodes.ncoor == 2)
     ct  = 1 : 2; cr  = 3;      % pos. to get data
     ctx = 2 : 3; crx = 4;      % pos. to store data
     rot = mxdofpnt == 3;
  else
     ct  = 1 : 3; cr  = 4 : 6;  % pos. to get data
     ctx = 2 : 4; crx = 2 : 4;  % pos. to store data
     rot = mxdofpnt == 6;
  end

# Loop over loadcases

  for l = 1 : nlc

      ix        = vect(l).id;
      out       = zeros(4, cmp.nodes.nofnod);
      out(1, :) = cmp.nodes.ids;

#     Translations: Header

      fprintf(fid, "$NodeData\n");

#     Translations: Tags

      fprintf(fid, "1\n\"%s\"\n", title{l, 1});
      fprintf(fid, "1\n%f\n", zero);
      fprintf(fid, "3\n%d\n3\n%d\n", 0, nofnod);

#     Translations: Data

      out(ctx, ix) = vect(l).d(:, ct)';
      fprintf(fid, "%d %e %e %e\n", out);

#     Translations: End

      fprintf(fid, "$EndNodeData\n");

      if (rot)

#     Rotations: Header

         fprintf(fid, "$NodeData\n");

#     Rotations: Tags

         fprintf(fid, "1\n\"%s\"\n", title{l, 2});
         fprintf(fid, "1\n%f\n", zero);
         fprintf(fid, "3\n%d\n3\n%d\n", 0, nofnod);

#     Rotations: Data

         out(crx, ix) = vect(l).d(:, cr)';
         fprintf(fid, "%d %e %e %e\n", out);

#     End

         fprintf(fid, "$EndNodeData\n");

      endif

  endfor

endfunction
