function [mot, nofmot] = mfs_readmotion(nofmot, mot, group, nodes)

# usage: [mot, nofmot] = mfs_readmotion(nofmot, mot, group, nodes)
#
# Input  nofmot   Number of definitions in mot
#        mot      Structure with definitions of motion
#        group    Structure with data of physical group
#        nodes    Array with with nodel point indices
#
# Output mot      Updated structure with definitions of motion
#        nofmot   Updated number of definitions
#
# Fields of structure mot:
#   mot.ids(nofmot, 1)   Nodal point identifier
#   mot.ids(nofmot, 2)   Loadcase identifier
#   mot.ids(nofmat, 3)   Index of data in cell array data
#   mot.data{:}          Motion data
#
# ------------------------------------------------------------------------

  if (isfield(group, "lc"))
     lc = group.lc;
  else
     lc = 1;
  end

  [ne, nofnod] = size(nodes);
  newmot = ne * nofnod;
  ids    = zeros(newmot, 3);

  ids(:, 1) = vec(nodes);
  ids(:, 2) = lc(ones(newmot, 1));

  if (nofmot)
     k = length(mot.data) + 1;
     ids(:, 3) = k(ones(newmot, 1));
     mot.ids   = [mot.ids; ids];
     mot.data  = [mot.data, group.data];
  else
     ids(:, 3)   = ones(newmot, 1);
     mot.ids     = ids;
     mot.data{1} = group.data;
  end

  nofmot += newmot;

end
