function [ids, axes] = mfs_axes_q4(elem)

# usage: [ids, axes] = mfs_axes_q4(elem)
#
# Input  elem(:)     Stucture array with element data
#
# Output ids(:)      Element identifiers
#        axes(:, 9)  Element axis vectors
#        rc          Return code: 0 = no errors
#                                 1 = errors
#
# This function computes the vectors of the element coordinates system
# of quadrilateral elements.
#
# ------------------------------------------------------------------------

# Initialize

  nel  = length(elem);
  ids  = zeros(nel, 1);
  axes = zeros(nel, 9);

# Loop over elements

  for n = 1 : nel

      ids(n) = elem(n).id;
      coor   = elem(n).coor;
      
      C   = mean(coor);
      M23 = mean(coor([2, 3], :));
      M34 = mean(coor([3, 4], :));

      ex = M23 - C;
      ex = ex / norm(ex);

      c2 = M34 - C;
      ez = cross(ex, c2);
      ez = ez / norm(ez); 

      ey = cross(ez, ex);

      axes(n, :) = [ex, ey, ez];

  end

end
