function mfs_exp_cstress2d(fid, elres, title)

# usage: mfs_exp_cstress2d(fid, elres, title)

# Input  fid         File handle of output file
#        elres       Structure with element results
#        title(:)    Cell array with view names
#
# The function exports complex stresses of 2-dimensional elements in 
# Gmsh MSH file format. The real part is written as time step 0 and
# the imaginary part as time step 1.
#
# --------------------------------------------------------------------

  zero = 0;

# Define output formats

  f3e = " %-10.3e %-10.3e %-10.3e";
  fst = cstrcat("%-5d", f3e, f3e, f3e, "\n");

# Get number of elements with stresses

  nofelt = 0;

  for ntype = 1 : elres.noftyp
      if (elres.types(ntype).rtype > 1)
         nofelt += elres.types(ntype).nofelt;
      end
  end

# Loop over frequencies

  for l = 1 : elres.nofcol

#     Real Part

%     Header

      fprintf(fid, "$ElementData\n");

#     Tags

      fprintf(fid, "1\n""%s""\n", title{l});
      fprintf(fid, "1\n%-10.3f\n", zero);
      fprintf(fid, "3\n%-3d\n9\n%-5d\n", 0, nofelt);

      for ntype = 1 : elres.noftyp

          nelt = elres.types(ntype).nofelt;
          m1   = elres.types(ntype).ixelt1;
          m2   = m1 + nelt - 1;

          switch elres.types(ntype).rtype

            case 2  % rod
              R = zeros(1, 9);
              for m = m1 : m2
                  R(1) = real(elres.elem(m).results.sig(l));
                  fprintf(fid, fst, elres.elem(m).id, R);
              end

            case 3  % plane stress
              for m = m1 : m2
                  R   = zeros(1, 9);
                  sig = real(elres.elem(m).results.sig(:, l, :));
                  sig = squeeze(sig);
                  for p = 1 : elres.elem(m).nofpnt
                      R(1) += sig(1, p);
                      R(2) += sig(3, p);
                      R(4) += sig(3, p);
                      R(5) += sig(2, p);
                  end
                  R = R / elres.elem(m).nofpnt;
                  fprintf(fid, fst, elres.elem(m).id, R);
              end
          end

      end   % Loop over element types

#     End

      fprintf(fid, "$EndElementData\n");

#     Imaginary Part

%     Header

      fprintf(fid, "$ElementData\n");

#     Tags

      fprintf(fid, "1\n""%s""\n", title{l});
      fprintf(fid, "1\n%-10.3f\n", zero);
      fprintf(fid, "3\n%-3d\n9\n%-5d\n", 1, nofelt);

      for ntype = 1 : elres.noftyp

          nelt = elres.types(ntype).nofelt;
          m1   = elres.types(ntype).ixelt1;
          m2   = m1 + nelt - 1;

          switch elres.types(ntype).rtype

            case 2  % rod
              R = zeros(1, 9);
              for m = m1 : m2
                  R(1) = imag(elres.elem(m).results.sig(l));
                  fprintf(fid, fst, elres.elem(m).id, R);
              end

            case 3  % plane stress
              for m = m1 : m2
                  R   = zeros(1, 9);
                  sig = imag(elres.elem(m).results.sig(:, l, :));
                  sig = squeeze(sig);
                  for p = 1 : elres.elem(m).nofpnt
                      R(1) += sig(1, p);
                      R(2) += sig(3, p);
                      R(4) += sig(3, p);
                      R(5) += sig(2, p);
                  end
                  R = R / elres.elem(m).nofpnt;
                  fprintf(fid, fst, elres.elem(m).id, R);
              end
          end

      end   % Loop over element types

#     End

      fprintf(fid, "$EndElementData\n");

  end       % Loadcase loop

end
