function mfs_exp_rslt(fid, elres, title)

# usage: mfs_exp_rslt(fid, elres,title)

# Input  fid         File handle of output file
#        elres       Structure with element results
#        title(:)    Cell array with view names
#
# The function exports stress resultants in Gmsh MSH file format.
#
# --------------------------------------------------------------------

  zero = 0;

# Define indices to rearrange data

  switch elres.subtype
    case "2d"
      ib2 = [1, 2, 6];   % N, Qy, Mz
    case "3d"
      ib2 = 1 : 6;       % N, Qy, Qz, Mx, My, Mz
  end

# Define output formats

  fe  = " %-10.3e %-10.3e %-10.3e";
  fl1 = cstrcat("%-5d", fe, fe, fe, "\n");

# Get number of elements with resultants

  nofelt = 0;

  for ntype = 1 : elres.noftyp
      switch elres.types(ntype).rtype
        case {1, 2, 4}
          nofelt += elres.types(ntype).nofelt;
      end
  end

# Loop over loadcases

  for l = 1 : elres.nofcol

#     Header

      fprintf(fid, "$ElementData\n");

#     Tags

      fprintf(fid, "1\n""%s""\n", title{l});
      fprintf(fid, "1\n%-10.3f\n", zero);
      fprintf(fid, "3\n%-3d\n9\n%-5d\n", 0, nofelt);

      for ntype = 1 : elres.noftyp

          nelt = elres.types(ntype).nofelt;
          m1   = elres.types(ntype).ixelt1;
          m2   = m1 + nelt - 1;

          switch elres.types(ntype).rtype

            case 1  % beam
              R = zeros(1, 9);
              for m = m1 : m2
                  R(ib2) = elres.elem(m).results.rslt(:, l);
                  fprintf(fid, fl1, elres.elem(m).id, R);
              end

            case 2  % rod
              R = zeros(1, 9);
              for m = m1 : m2
                  R(1) = elres.elem(m).results.rslt(l);
                  fprintf(fid, fl1, elres.elem(m).id, R);
              end

            case 4  % shell
              R = zeros(1, 9);
              for m = m1 : m2
                  R(1 : 8) = elres.elem(m).results.rslt(:, l);
                  fprintf(fid, fl1, elres.elem(m).id, R);
              end

          end

      end   % Loop over element types

#     End

      fprintf(fid, "$EndElementData\n");

  end       % Loadcase loop

end
