function mfs_exp_stress2d(fid, elres, title)

# usage: mfs_exp_stress2d(fid, elres, title)

# Input  fid         File handle of output file
#        elres       Structure with element results
#        title(:)    Cell array with view names
#
# The function exports stresses of 2-dimensional elements in 
# Gmsh MSH file format.
#
# --------------------------------------------------------------------

  zero = 0;

# Define output formats

  fst = "%d %e %e %e %e %e %e %e %e %e\n";

# Get number of elements with stresses

  nofelt = 0;

  for ntype = 1 : elres.noftyp
      if (elres.types(ntype).rtype > 1)
         nofelt += elres.types(ntype).nofelt;
      endif
  endfor

# Loop over loadcases

  for l = 1 : elres.nofcol

#     Header

      fprintf(fid, "$ElementData\n");

#     Tags

      fprintf(fid, "1\n\"%s\"\n", title{l});
      fprintf(fid, "1\n%f\n", zero);
      fprintf(fid, "3\n%d\n9\n%d\n", 0, nofelt);

      for ntype = 1 : elres.noftyp

          nelt = elres.types(ntype).nofelt;
          m1   = elres.types(ntype).ixelt1;
          m2   = m1 + nelt - 1;

          switch elres.types(ntype).rtype

            case 2  % rod
              R = zeros(1, 9);
              for m = m1 : m2
                  R(1) = elres.elem(m).results.sig(l);
                  fprintf(fid, fst, elres.elem(m).id, R);
              endfor

            case 3  % plane stress
              for m = m1 : m2
                  R = zeros(1, 9);
                  for p = 1 : elres.elem(m).nofpnt
                      R(1) += elres.elem(m).results.sig(1, l, p);
                      R(2) += elres.elem(m).results.sig(3, l, p);
                      R(4) += elres.elem(m).results.sig(3, l, p);
                      R(5) += elres.elem(m).results.sig(2, l, p);
                  endfor
                  R = R / elres.elem(m).nofpnt;
                  fprintf(fid, fst, elres.elem(m).id, R);
              endfor

          endswitch

      endfor   % Loop over element types

#     End

      fprintf(fid, "$EndElementData\n");

  endfor       % Loadcase loop

endfunction
