function mfs_exp_tstress2d(fid, elres, t, title)

# usage: mfs_exp_tstress2d(fid, elres, t, title)

# Input  fid         File handle of output file
#        elres       Structure with element results
#        t(:)        Time steps
#        title       View name
#
# The function exports time-dependent stresses of 2-dimensional
# elements in Gmsh MSH file format.
#
# --------------------------------------------------------------------

# Define output formats

  f3e = " %-10.3e %-10.3e %-10.3e";
  fst = cstrcat("%-5d", f3e, f3e, f3e, "\n");

# Get number of elements with stresses

  nofelt = 0;

  for ntype = 1 : elres.noftyp
      if (elres.types(ntype).rtype > 1)
         nofelt += elres.types(ntype).nofelt;
      end
  end

# Loop over time steps

  for l = 1 : elres.nofcol

#     Header

      fprintf(fid, "$ElementData\n");

#     Tags

      fprintf(fid, "1\n""%s""\n", title);
      fprintf(fid, "1\n%-10.3e\n", t(l));
      fprintf(fid, "3\n%-3d\n9\n%-5d\n", l - 1, nofelt);

      for ntype = 1 : elres.noftyp

          nelt = elres.types(ntype).nofelt;
          m1   = elres.types(ntype).ixelt1;
          m2   = m1 + nelt - 1;

          switch elres.types(ntype).rtype

            case 2  % rod
              R = zeros(1, 9);
              for m = m1 : m2
                  R(1) = elres.elem(m).results.sig(l);
                  fprintf(fid, fst, elres.elem(m).id, R);
              end

            case 3  % plane stress
              for m = m1 : m2
                  R = zeros(1, 9);
                  for p = 1 : elres.elem(m).nofpnt
                      R(1) += elres.elem(m).results.sig(1, l, p);
                      R(2) += elres.elem(m).results.sig(3, l, p);
                      R(4) += elres.elem(m).results.sig(3, l, p);
                      R(5) += elres.elem(m).results.sig(2, l, p);
                  end
                  R = R / elres.elem(m).nofpnt;
                  fprintf(fid, fst, elres.elem(m).id, R);
              end
          end

      end   % Loop over element types

#     End

      fprintf(fid, "$EndElementData\n");

  end       % Loop over time steps

end
