function pdofs = mfs_packdofs(dofs)

# usage: pdofs = mfs_packdofs(dofs)
#
# Input  dofs(:)    Degree of freedom list
# Output pdofs      Packed degree of freedom description
#
# The function generates a packed degree of freedom description from
# a degree of freedom list. The packed degree of freedom description
# is a word with 1-bits at the positions of the corresponding degrees
# of freedom.
#
# ------------------------------------------------------------------------

  pdofs = 0;

  for k = dofs
      pdofs = bitset(pdofs, k);
  end

end
