function sig3d = mfs_sig2dto3d(T, sig2d, np)

# usage: sig3d = mfs_sig2dto3d(T, sig2d, np)
#
# Input  T(3, 3)       Transformation matrix to element system
#        sig2d(3, np)  2-d stresses sigx, sigy, tauxy
#        np            Number of stress points
#
# Output sig3d(9)      3-d stress tensor (mean values)
#
# The function computes the components of the 3-dimensional stress
# tensor from the 2-dimensional stresses of membrane # elements in 
# 3-dimensional space.
#
# --------------------------------------------------------------------

# Loop over stress points

  sig3d = zeros(9, 1);

  for p = 1 : np

      sig = [sig2d(1, p), sig2d(3, p), 0; 
             sig2d(3, p), sig2d(2, p), 0; 
                       0,           0, 0];
      sig = T' * sig * T;

      sig3d += [sig(:, 1); sig(:, 2); sig(:, 3)];

  end

  sig3d = sig3d / np;

end

