function dofs = mfs_unpackdofs(pdofs)

# usage: dofs = mfs_unpackdofs(pdofs)
#
# Input  pdofs      Packed degree of freedom description
# Output dofs(:)    Degree of freedom list
#
# The function generates a degree of freedom list from a packed degree
# of freedom description. The packed degree of freedom description
# is a word with 1-bits at the positions of the corresponding degrees
# of freedom.
#
# ------------------------------------------------------------------------

  maxbit = floor(log2(pdofs)) + 1;
  ndofs  = 0;

  for k = 1 : maxbit
      if(bitget(pdofs, k))
         dofs(++ndofs) = k;
      end
  end

end
