function data = mfs_merge_read(fid)

# usage: data = mfs_merge_read(fid)
#
# Input  fname  File handle of file to read
#
# Output data   Structure with contents of input file
#
# The function reads a file in Gmsh msh format 2.2 The following
# datablocks are supported:
#
#   PhysicalNames
#   Nodes
#   Elements
#   NodeData
#
# --------------------------------------------------------------------

# Check arguments

  if (nargin != 1 || nargout != 1)
     print_usage();
  end

# Initialize

  data         = struct();
  data.nblocks = 0;         % Number of $NodeData blocks

# Process the contents

  while ((line = fgetl(fid)) != -1)

     key = sscanf(line, "%s");

     switch key

     case "$PhysicalNames"
        printf("               found datablock $PhyscialNames\n");
        data.nprops = fscanf(fid, "%d\n", 1);
        for n = 1 : data.nprops
            [props{1, n}, props{2, n}, props{3, n}] = ...
            fscanf(fid, "%d %d %s\n", "C");
        end
        data.props = props;
        line = fgetl(fid);

     case "$Nodes"
        printf("               found datablock $Nodes\n");
        data.nnodes = fscanf(fid, "%d\n", 1);
        for n = 1 : data.nnodes
            [nodes{1, n}, nodes{2, n}, nodes{3, n}, nodes{4, n}] = ...
            fscanf(fid, "%d %f %f %f\n", "C");
        end
        data.nodes  = nodes;
        data.maxnod = nodes{1, end};
        line = fgetl(fid);

     case "$Elements"
        printf("               found datablock $Elements\n");
        data.nelem    = fscanf(fid, "%d\n", 1);
        data.elements = cell(1, data.nelem);
        for n = 1 : data.nelem
            [id, type, grpid, elnodes] = mfs_readelt(fid);
            elem(1) = id;    elem(2) = type;
            elem(3) = grpid; elem(4) = grpid;
            element = {elem, elnodes};
            data.elements{n} = element;
        end
        data.maxelt = id;
        line = fgetl(fid);

     case "$NodeData"
        printf("               found datablock $NodeData\n");
        nb = ++data.nblocks;
        line = fgetl(fid);
        nodedata.title = fgetl(fid);
        line = fgetl(fid); line = fgetl(fid); line = fgetl(fid);
        nodedata.tstpno = fscanf(fid, "%d/n", 1);
        nodedata.ndata  = fscanf(fid, "%d\n", 1);
        nodedata.nofnod = fscanf(fid, "%d\n", 1);
        for n = 1 : nodedata.nofnod
            nodedata.id(n) = fscanf(fid, "%d", 1);
            val = fscanf(fid, "%f\n", nodedata.ndata);
            nodedata.data{n} = val;
        end
        data.nodedata{nb} = nodedata;
        line = fgetl(fid);

     otherwise

        mfs_skip(fid);

     end

  end

end
