function [id, etype, groupid, nodes] = mfs_readelt(fid)

# usage: [id, etype, groupid, nodes] = mfs_readelt(fid)
#
# Input  fid       Input file handle
#
# Output id        Element identifier
#        etype     Gmsh element type
#        groupid   Physical group identifier
#        nodes(:)  List of element nodes
#
# The function reads one element record from the input file (verion 2.2
# file format).
#
# ------------------------------------------------------------------------

  line  = fgetl(fid);
  words = strsplit(line);
  nw    = length(words);

  id      = sscanf(words{1}, "%d");
  etype   = sscanf(words{2}, "%d");
  ntags   = sscanf(words{3}, "%d");
  groupid = sscanf(words{4}, "%d");

  n = 0;
  for k = 4 + ntags : nw
      nodes(++n) = sscanf(words{k}, "%d");
  end

end
