function [ids, nofnod, nodes] = mfs_readelt(fid, ne)

# usage: [ids, nodes] = mfs_readelt(fid, ne)
#
# Input  fid                Input file handle
#        ne                 Number of element records to read
#
# Output ids(ne)            Element identifiers
#        nofnod             Number of nodes per element
#        nodes(ne, nofnod)  List of element nodes
#
# The function reads element records from the input file (version 4.1
# file format).
#
# ------------------------------------------------------------------------

  for n = 1 : ne

      line  = fgetl(fid);
      items = sscanf(line, "%d");

      ids(n) = items(1);
      nodes(n, :) = items(2 : end)';

  end

  nofnod = columns(nodes);

end
