function mfs_exp_elts(fid, eltx)

# usage: mfs_exp_elts(fid, eltx)
#
# Input:  fid   File handle of output file
#         eltx  Structure with element data
#
# The function outputs the element data in Gmsh 4.1 format.
#
# ----------------------------------------------------------------------

# Check arguments

  if (nargin != 2 || nargout != 0)
     print_usage();
  end

# Header

  fprintf(fid, "$Elements\n");
  fprintf(fid, "%d %d %d %d\n", eltx.numEntityBlocks,
          eltx.numElements, eltx.minElementTag, eltx.maxElementTag); 

# Blocks

  for l = 1 : eltx.numEntityBlocks
      blck = eltx.blocks(l);
      fprintf(fid, "%d %d %d %d\n", blck.entityDim, blck.entityTag,
              blck.elementType, blck.numElementsInBlock);
      nopel = rows(blck.nodeTag);
      fmt   = cell(1, 1 : nopel);
      fmt(1 : nopel) = " %d";
      fmt   = ["%d", strjoin(fmt), "\n"];
      out   = [blck.elementTag(:)'; blck.nodeTag];
      fprintf(fid, fmt, out);
  endfor

# End

  fprintf(fid, "$EndElements\n");

endfunction
