function mfs_exp_nodedata(fid, nodedata)

# usage: mfs_exp_nodedata(fid, nodedata)
#
# Input:  fid   File handle of output file
#         nodx  Structure with nodal point data
#
# The function outputs nodal point results in Gmsh 4.1 format.
#
# ----------------------------------------------------------------------

# Check arguments

  if (nargin != 2 || nargout != 0)
     print_usage();
  endif

  for n = 1 : nodedata.numNodeData
      fprintf(fid, "$NodeData\n");
      blck = nodedata.blocks(n);
      fprintf(fid, "1\n%s\n", blck.title)
      fprintf(fid, "1\n%f\n", blck.tstep)
      fprintf(fid, "3\n%d\n%d\n%d\n",
              blck.tstepno, blck.numComp, blck.numNodes);
      fmt = cell(1, blck.numComp);
      fmt(1 : blck.numComp) = " %e"; 
      fmt = ["%d", strjoin(fmt), "\n"];
      fprintf(fid, fmt, blck.values);
      fprintf(fid, "$EndNodeData\n");
  endfor

endfunction
