function mfs_exp_nodes(fid, nodx)

# usage: mfs_exp_nodes(fid, nodx)
#
# Input:  fid   File handle of output file
#         nodx  Structure with nodal point data
#
# The function outputs the nodal point data in Gmsh 4.1 format.
#
# ----------------------------------------------------------------------

# Check arguments

  if (nargin != 2 || nargout != 0)
     print_usage();
  endif

# Header

  fprintf(fid, "$Nodes\n");
  fprintf(fid, "%d %d %d %d\n", nodx.numEntityBlocks,
          nodx.numNodes, nodx.minNodeTag, nodx.maxNodeTag); 

# Blocks

  for l = 1 : nodx.numEntityBlocks
      blck = nodx.blocks(l);
      fprintf(fid, "%d %d 0 %d\n", blck.entityDim, blck.entityTag,
              blck.numNodesInBlock);
      fprintf(fid, "%d\n", blck.nodeTag);
      fprintf(fid, "%f %f %f\n", blck.xyz);
  endfor

# End

  fprintf(fid, "$EndNodes\n");

endfunction
