function [ids, nofnod, nodes] = mfs_readelt(fid, nofelt)

# usage: [ids, nofnod, nodes] = mfs_readelt(fid, nofelt)
#
# Input  fid                Input file handle
#        nofelt             Number of element records to read
#
# Output ids(nofelt)        Element identifiers
#        nofnod             Number of nodes per element
#        nodes(ne, nofnod)  List of element nodes
#
# The function reads element records from the input file (version 4.1
# file format).
#
# ------------------------------------------------------------------------

# First element to determine number of nodes per element

  line   = fgetl(fid);
  items  = sscanf(line, "%d");
  len    = length(items);
  nofnod = len - 1;

# Initialize output

  ids    = zeros(nofelt, 1);
  nodes  = zeros(nofelt, nofnod);

  ids(1) = items(1);
  nodes(1, :) = items(2 : len);

# Remaining elements

  if (nofelt > 1)
     fmt = cell(1, 1 : len);
     fmt(1 : nofnod) = " %d";
     fmt = ["%d", strjoin(fmt), "\n"];
     val = fscanf(fid, fmt, [len, nofelt - 1]);
     ids(2 : end) = val(1, :);
     nodes(2 : end, :) = val(2 : end, :)';
  endif

end
