function [fid, vers, rc] = mfs_mshfileopen(fname)

# usage: [fid, vers, rc] = mfs_mshfileopen(fname)
#
# Input  fname    Name of input file
#
# Output fid      File handle 
#        vers     File format version
#        rc       Return code: 0 = no errors, 1 = errors 
#
# The function opens a msh file and returns ther mesh file version.
#
# -----------------------------------------------------------------------------

  vers = [];
  rc   = 1;

# Open the file

  if (ispc)
     fmode = "r";
  else
     fmode = "rt";
  endif

  if ((fid = fopen(fname, fmode)) == -1)
     printf("*E* mfs_merge: could not open file %s\n", fname);
     return;
  endif

  line = fgetl(fid);
  if (! strcmp(line, "$MeshFormat"))
     printf("*E* mfs_merge: file \"%s\" is corrupted\n", fname);
     return;
  endif

  line  = fgetl(fid);
  words = strsplit(line);
  vers  = words{1};

  line = fgetl(fid);
  if (! strcmp(line, "$EndMeshFormat") )
     printf("*E* mfs_merge: file \"%s\" is corrupted\n", fname);
     return;
  endif

  switch vers
  case {"2.2", "4.1"}
     rc = 0;
  otherwise
     printf("*E* mfs_merge: MSH file version %s is not supported\n",
           format);
  endswitch
  
endfunction
