function opts = mfs_defopts(opts, defopts)

# usage: opts = mfs_defopts(opts, defopts)
#
# Input  opts     Structure with options
#        defopts  Structure with default options
#
# Output opts     Structure with default options inserted
#
# The function inserts the defaults for all options that are not
# defined in opts.
#
# --------------------------------------------------------------------

# Check arguments

  if (nargin != 2 || nargout != 1)
     print_usage();
  end

  for [val, name] = defopts
      if (! isfield(opts, name))
         opts = setfield(opts, name, val);
      end
  end

end
