function mfs_errexit(text, fid)

# usage: mfs_errexit(text, fid)
#
# Input  text    Error text
#        fid     Identifier of output file
#
# The function handles an error exit if error messages have been
# written to the output file. If GNU Octave is running in GUI mode,
# the output file is opened in the editor.
#
# -------------------------------------------------------------------

  fname  = fopen(fid);
  fclose(fid);

  text2  = sprintf("\n       See file %s for more information.\n", 
                   fname);
  errmsg = [text, text2];

  if (isguirunning())
     beep();
     edit(fname);
  end

  error(errmsg);

end
