function vers = mfs_mshfileversion(msg, fid, fname)

# usage: vers = mfs_mshfileversion(msg, fid, fname)
#
# Input  msg      File handle of message file
#        fid      File handle of input file
#        fname    Name of input file
#
# Output vers     File format version
#
# The function reads the mesh file version from the input file and
# checks if the version is supported.
#
# -----------------------------------------------------------------------------

  vers = [];

  line = fgetl(fid);
  if (! strcmp(line, "$MeshFormat"))
     fclose(msg);
     error("mfs_import: file \"%s\" is corrupted\n", fname);
  end

  line  = fgetl(fid);
  words = strsplit(line);
  vers  = words{1};
  fprintf(msg, "Reading model from file \"%s\", ", fname);
  fprintf(msg, "MSH file version %s\n\n", vers);

  line = fgetl(fid);
  if (! strcmp(line, "$EndMeshFormat") )
     fclose(msg);
     error("mfs_import: file \"%s\" is corrupted\n", fname);
  end

  switch vers
  case {"2.2", "4.1"}
  otherwise
     fclose(msg);
     error("mfs_import: MSH file version %s is not supported\n",
           vers);
  end
  
end
