function mfs_paths(action, fname, varargin)

# usage: mfs_paths(action, fname, varargin)
#
# Input  action    "add"     add paths to search path
#                  "remove"  remove paths from search directory
#        fname     Name of a function file in the directory
#                  containing the paths
#        varargin  Paths to be added
#
# The function managages the Mefisto search paths
#
# -------------------------------------------------------------------

  persistent saved_paths = [];

  switch action

  case "add"
     if (nargin < 3)
        error("mfs_paths: action \"add\" needs file name and paths\n");
     else
        mpath = file_in_loadpath(fname);
        len   = length(mpath);
        if (! len)
           error("mfs_paths: file %s not found\n", fname);
        end
        len   = len - length(fname);
        paths = strcat(mpath(1 : len), varargin);
        for p = paths
            addpath(p{1});
        end
        if (iscell(saved_paths))
           saved_paths = [saved_paths, paths];
        else
           saved_paths = paths;
        end
     end

  case "remove"
     if (iscell(saved_paths))
        for p = saved_paths
            rmpath(p{1});
        end
        saved_paths = [];
     end

  otherwise
     error("mfs_paths: unknown action \"%s\"\n", action);
  end

end
