function k = mfs_ke(elem)

# usage: k = mfs_ke(elem)
#
# Input  elem     Structure containing data of one element
#
# Output k        Element stiffness matrix
#
# The function computes the stiffness matrix of a 2-dimensional beam 
# element.
#
# -------------------------------------------------------------------

# Geometry

  d = elem.coor(2, :) - elem.coor(1, :);
  L = sqrt(d(1)^2 + d(2)^2);
  c = d(1) / L;
  s = d(2) / L;

# Stiffness in element coordinate system

  ka   = elem.mat.E * elem.geom.A / L;
  ki   = elem.mat.E * elem.geom.I / L^3;
  k12  = 12 * ki;
  k6L  = 6 * ki * L ;
  k2Lq = 2 * ki * L^2;

  kE = [ ka , 0, 0, -ka, 0, 0;
         0, k12, k6L, 0, -k12, k6L;
         0, k6L, 2 * k2Lq, 0, -k6L, k2Lq;
         -ka, 0, 0, ka, 0, 0;
         0, -k12, -k6L, 0, k12, -k6L;
         0, k6L, k2Lq, 0, -k6L, 2 * k2Lq ];

# Transformation matrix to structure coordinate system

  T33 = [c, s, 0; -s, c, 0; 0, 0, 1];
  Z33 = zeros(3, 3, "double");
  T   = [T33, Z33; Z33, T33];

# Stiffness matrix in structure coordinate system

  k = T' * kE * T;

end
