function m = mfs_mle(elem)

# usage: m = mfs_mle(elem)
#
# Input  elem     Structure containing data of one element
#
# Output m        Element mass matrix
#
# The function computes the lumped mass matrix of a 2-dimensional
# beam element.
#
# -------------------------------------------------------------------

# Mass of the element

  if (isfield(elem.mat, "rho"))
     d = elem.coor(2, :) - elem.coor(1, :);
     L = sqrt(d(1)^2 + d(2)^2);  
     mE = L * elem.geom.A * elem.mat.rho;
  else
     m = sparse(6, 6);
     return;
  end

# Mass matrix

  mE = 0.5 * mE;
  m  = diag([mE, mE, 0, mE, mE, 0]);

end
