function eldata = mfs_defelt()

# usage: eldata = mfs_defelt()
#
# Output eldata   Structure with element type data:
#                   name     element name
#                   nelnod   number of element nodes
#                   ndofnod  number of dofs per node
#                   mat      indicates if material data are needed (0 or 1)
#                   geom     indicates if geometrical data are needed (0 or 1)
#                   gmshid   gmsh element type
#                   rtype    result type: 2 = rod
#                   axes     axes type:   0 = none
#
# The function returns the data of a 2-dimensional g2-element.
#
# -----------------------------------------------------------------------------

  eldata = struct("name", "g2",
                  "nelnod",  2,
                  "ndofnod", 0, 
                  "mat",     0,
                  "geom",    0,
                  "gmshid",  1,
                  "rtype",   0,
                  "axes",    0);

end
