function rc = mfs_chkelt(msg, elem, Lmin)

# usage: rc = mfs_chkelt(msg, elem, Lmin)
#
# Input  msg    File handle of message file
#        elem   Structure with element data
#        Lmin   Minimum element length
#
# Ouput  rc     Return code: 0 means no erros
#                            1 means erros
#
# The function performs basic checks of 1-dimensional rigid body mass.
#
# ----------------------------------------------------------------------------

# Initialize

  geom_fields = {"m", "J"};
  rc  = 0;

# Loop over elements

  for el = elem

      geom = el.geom;
      rce = mfs_checkfields2(msg, geom, geom_fields, "Element", el.id);
      if (! rce)
         if (geom.m < 0)
            fprintf(msg, "*E* Element %5d: Illegal value of \"geom.m\"\n", ...
                    el.id);
            rce = 1;
         end
         if (geom.J < 0)
            fprintf(msg, "*E* Element %5d: Illegal value of \"geom.J\"\n", ...
                    el.id);
            rce = 1;
         end
      end

      rce = rce | mfs_checkfields3(msg, geom, geom_fields, "Element", el.id);

      rc = rc | rce;

  end

end
