function m = mfs_mce(elem)

# usage: m = mfs_mce(elem)
#
# Input  elem     Structure containing data of one element
#
# Output m        Element mass matrix
#
# The function computes the mass matrix of a 2-dimensional rigid body
# element.
#
# -------------------------------------------------------------------

  mE = elem.geom.m;
  J  = elem.geom.J;

  m = [mE, 0, 0; 0, mE, 0; 0, 0, J];

end
