function mfs_pltelt(nofelt, elem);

# usage: mfs_pltelt(nofelt, elem)
#
# Input nofelt    Number of elements 
#       elem      Structure with element data
#
# The function plots m2 elements.
#
# Description of the element structure:
#
#   elem.id                  Element identifier
#   elem.nodes(:)            Identifiers of element nodal points
#   elem.coor(:, 2)          Coordinates of element nodal points
#   elem.ects(:)             Element connectivity table
#   elem.mat                 Structure with element material data
#   elem.geom                Structure with element geometry data 
#
# ------------------------------------------------------------------------

  global pltparm;

# Plot elements

  for nel = 1 : nofelt
      x = elem(nel).coor(1);
      y = elem(nel).coor(2);
      line(x, y, "marker", "x","markersize", 10);
  end

# Plot element identifiers

  if (pltparm.eltid == 1)
     for nel = 1 : nofelt
         label = sprintf("%i", elem(nel).id);
         x = elem(nel).coor(1);
         y = elem(nel).coor(2);
         text(x, y, label, "fontsize", pltparm.fontsize);
     end
  end

end
