function kE = mfs_ke(elem)

# usage: kE = mfs_ke(elem)
#
# Input  elem     Structure containing data of one element
#        id       Element identifier
#
# Output kE       Element stiffness matrix
#
# The function computes the stiffness matrix of a linear 2-dimensional
# quadrilateral isoparametric membrane element with 4 nodes.
#
# ------------------------------------------------------------------------

  persistent ng; persistent r;
  persistent  s; persistent w;

# Initialize Gauss integration

  if (isempty(ng))
     ng = 4; 
     f  = 1 / sqrt(3);
     r  = [ -f, f, -f, f];
     s  = [ -f, -f, f, f];
     w  = [ 1, 1, 1, 1];
  end

# Material matrix, thickness and coordinates

  E    = mfs_emat2d(elem.mat);
  E22  = E([1 : 2], [1 : 2]);
  G    = E(3, 3);
  t    = elem.geom.t;
  coor = elem.coor;

# Initialization

  kE = zeros(8, 8, "double");

# Integration Loop

  for n = 1 : ng
      [BE, JE] = mfs_BEE_q4(r(n), s(n), coor(:, 1), coor(:, 2));
      wdV = w(n) * JE * t;
      kE = kE + BE' * (E22 * wdV) * BE;
  end

  [BEG, JE] = mfs_BEG_q4(0, 0, coor(:, 1), coor(:, 2));
  wdV = 4 * JE * t;
  kE  = kE + BEG' * (G * wdV) * BEG;

end
