function m = mfs_mce(elem)

# usage: m = mfs_mce(elem)
#
# Input  elem     Structure containing data of one element
#
# Output m        Element mass matrix
#
# The function computes the consistent mass matrix of a 2-dimensional
# quadrilateral isoparametric membrane element with 4 nodes.
#
# -------------------------------------------------------------------

  persistent ng; persistent r;
  persistent  s; persistent w;

# Initialize Gauss integration

  if (isempty(ng))
     ng = 4;
     f  = 1 / sqrt(3);
     r  = [ -f, f, -f, f];
     s  = [ -f, -f, f, f];
     w  = [ 1, 1, 1, 1];
  end

# Initialize result

  m   = sparse(8, 8);
  m44 = zeros(4, 4, "double");

# Mass density

  if (isfield(elem.mat, "rho"))
     rho = elem.mat.rho;
  else
     return;
  end

# Degree of freedom indices

  u = 1 : 2 : 7;
  v = 2 : 2 : 8; 

# Integration loop

  coor = elem.coor;
  for n = 1 : ng
      JE = mfs_JE_q4(r(n), s(n), coor(:, 1), coor(:, 2));
      wdA = w(n) * JE;
      N   = mfs_NE_q4(r(n), s(n));
      m44 += N' * N * wdA;
  end

  m44     = rho * elem.geom.t * m44;
  m(u, u) = m44;
  m(v, v) = m44;

end
