function m = mfs_mle(elem)

# usage: m = mfs_mle(elem)
#
# Input  elem     Structure containing data of one element
#
# Output m        Element mass matrix
#
# The function computes the lumped mass matrix of a 2-dimensional
# quadrilateral isoparametric membrane element with 4 nodes.
#
# -------------------------------------------------------------------

# Mass density

  if (isfield(elem.mat, "rho"))
     rho = elem.mat.rho;
  else
     m = sparse(8, 8);
     return;
  end

# Area

  ib    = [2, 3, 4, 1];
  coor  = elem.coor;
  edges = coor(ib, :) - coor;
  A     = 0.5 * (det(edges(1 : 2, :)) + det(edges(3 : 4, :)));

# Mass matrix

  m = 0.25 * rho * elem.geom.t * abs(A) * speye(8); 

end
