function m = mfs_mce(elem)

# usage: m = mfs_mce(elem)
#
# Input  elem     Structure containing data of one element
#
# Output m        Element mass matrix
#
# The function computes the consistent mass matrix of a 2-dimensional
# quadrilateral membrane element with 4 nodes and drilling dofs.
#
# -------------------------------------------------------------------

  persistent ng; persistent r;
  persistent  s; persistent w;

# Initialize Gauss integration (cf. Bathe)

  if (isempty(ng))
     ng = 9;
     f = sqrt(3/5);
     r = [ -f, 0, f, -f, 0, f, -f, 0, f];
     s = [ -f, -f, -f, 0, 0, 0, f, f, f];
     w = [ 25, 40, 25, 40, 64, 40, 25, 40, 25] / 81;
  end

# Mass density

  if (isfield(elem.mat, "rho"))
     rho = elem.mat.rho;
  else
     m = sparse(12, 12);
     return;
  end

# Transformation matrix to q8

  coor = elem.coor;
  T    = mfs_rot2mid2d(coor);

# Add coordinates of midpoints

  ib   = [2, 3, 4, 1];
  coor = [coor; 0.5 * (coor + coor(ib, :))];

# Mass matrix of q8 element

  m88 = zeros(8, 8, "double");

  for n = 1 : ng
      JE = mfs_JE_q8(r(n), s(n), coor(:, 1), coor(:, 2));
      wdA = w(n) * JE;
      N   = mfs_NE_q8(r(n), s(n));
      m88 += N' * N * wdA;
  end

  m88 = rho * elem.geom.t * m88;

  u = 1 : 2 : 15; v = 2 : 2 : 16; 

  mq8 = zeros(16, 16, "double");
  mq8(u, u) = m88; mq8(v, v) = m88;

# Mass matrix of q4r element

  m = T' * mq8 * T;

end
