function m = mfs_mle(elem)

# usage: m = mfs_mle(elem)
#
# Input  elem     Structure containing data of one element
#
# Output m        Element mass matrix
#
# The function computes the lumped mass matrix of a 2-dimensional
# quadrilateral membrane element with 4 nodes and drilling dofs.
#
# -------------------------------------------------------------------

# Mass density

  if (isfield(elem.mat, "rho"))
     rho = elem.mat.rho;
  else
     m = sparse(12, 12);
     return;
  end

# Area

  ib    = [2, 3, 4, 1];
  coor  = elem.coor;
  edges = coor(ib, :) - coor;
  A     = 0.5 * (det(edges(1 : 2, :)) + det(edges(3 : 4, :)));

# Mass matrix

  v = zeros(12, 1, "double");
  v([1, 2, 4, 5, 7, 8, 10, 11]) = 0.25 * rho * elem.geom.t * abs(A);
  m = spdiags(v, 0, 12, 12);

end
