function kE = mfs_ke(elem)

# usage: kE = mfs_ke(elem)
#
# Input  elem     Structure containing data of one element
#
# Output kE       Element stiffness matrix
#
# The function computes the stiffness matrix of a 2-dimensional
# quadratic quadrilateral isoparametric membrane element with 8 nodes.
#
# ------------------------------------------------------------------------

  persistent ng; persistent r;
  persistent  s; persistent w;

# Initialize Gauss integration

  if (isempty(ng))
     ng = 9;
     f = sqrt(3/5);
     r = [ -f, 0, f, -f, 0, f, -f, 0, f];
     s = [ -f, -f, -f, 0, 0, 0, f, f, f];
     w = [ 25, 40, 25, 40, 64, 40, 25, 40, 25] / 81;
  end

# Material matrix

  E = mfs_emat2d(elem.mat);

# Initialization

  kE = zeros(16, 16, "double");

# Integration Loop

  t    = elem.geom.t;
  coor = elem.coor;
  for n = 1 : ng
      [BE, JE] = mfs_BE_q8(r(n), s(n), coor(:, 1), coor(:, 2));
      wdV = w(n) * JE * t;
      kE = kE + BE' * (E * wdV) * BE;
  end

end
