function m = mfs_mce(elem)

# usage: m = mfs_mce(elem)
#
# Input  elem     Structure containing data of one element
#
# Output m        Element mass matrix
#
# The function computes the consistent mass matrix of a 2-dimensional
# quadrilateral isoparametric membrane element with 8 nodes.
#
# -------------------------------------------------------------------

  persistent ng; persistent r;
  persistent  s; persistent w;

# Initialize Gauss integration

  if (isempty(ng))
     ng = 9;
     f = sqrt(3/5);
     r = [ -f, 0, f, -f, 0, f, -f, 0, f];
     s = [ -f, -f, -f, 0, 0, 0, f, f, f];
     w = [ 25, 40, 25, 40, 64, 40, 25, 40, 25] / 81;
  end

# Initialize result

  m = sparse(16, 16);

# Mass density

  if (isfield(elem.mat, "rho"))
     rho = elem.mat.rho;
  else
     return;
  end

# Degree of freedom indices

  u = 1 : 2 : 15;
  v = 2 : 2 : 16; 

# Integration loop

  m88 = zeros(8, 8, "double");

  coor = elem.coor;
  for n = 1 : ng
      JE = mfs_JE_q8(r(n), s(n),coor(:, 1), coor(:, 2));
      wdA = w(n) * JE;
      N   = mfs_NE_q8(r(n), s(n));
      m88 += N' * N * wdA;
  end

  m88     = rho * elem.geom.t * m88;
  m(u, u) = m88;
  m(v, v) = m88;

end
