function rc = mfs_chkelt(msg, elem, Lmin)

# usage: rc = mfs_chkelt(msg, elem, Lmin)
#
# Input  msg    File handle of message file 
#        elem   Structure with element data
#        Lmin   Minimum element length
#
# Ouput  rc     Return code: 0 means no erros
#                            1 means erros
#
# The function performs basic checks of rod elements.
#
# ----------------------------------------------------------------------------

# Initialize

  geom_fields = {"A"};
  rc  = 0;

# Loop over elements

  for el = elem

      geom = el.geom;
      rce = mfs_checkfields2(msg, geom, geom_fields, "Element", el.id);
      if (! rce && geom.A <= 0)
         fprintf(msg, "*E* Element %5d: Illegal value of \"geom.A\"\n", el.id);
         rce = 1;
      end

      rce = rce | mfs_checkfields3(msg, geom, geom_fields, "Element", el.id);

      if (norm(el.coor(2, :) - el.coor(1, :)) < Lmin)
         rce = 1;
         fprintf(msg, "*E* Rod %5d has zero length\n", el.id);
      end

      rce = rce | mfs_chkmat1d(msg, el.mat, el.id);

      rc = rc | rce;

  end

end
