function k = mfs_ke(elem)

# usage: k = mfs_ke(elem)
#
# Input  elem     Structure containing data of one element
#
# Output k        Element stiffness matrix
#
# The function computes the stiffness matrix of a 2-dimensional
# rod element.
#
# -------------------------------------------------------------------

# Geometry

  d  = elem.coor(2, :) - elem.coor(1, :);
  L  = norm(d);

# Stiffness in element coordinate system

  kE = (elem.mat.E * elem.geom.A / L) * [ 1, -1; -1, 1];

# Transformation matrix to structure coordinate system

  T = [ d(1), d(2), 0, 0; 0, 0, d(1), d(2) ] / L;  

# Stiffness matrix in structure coordinate system

  k = T' * kE * T;

end
