function m = mfs_mle(elem)

# usage: m = mfs_mle(elem)
#
# Input  elem     Structure containing data of one element
#
# Output m        Element mass matrix
#
# The function computes the lumped mass matrix of a 2-dimensional
# rod element.
#
# -------------------------------------------------------------------

# Mass of the element

  if (isfield(elem.mat, "rho"))
     d = elem.coor(2, :) - elem.coor(1, :);
     L = norm(d);
     mE = 0.5 * L * elem.geom.A * elem.mat.rho;
  else
     m = sparse(4, 4);
     return;
  end

# Mass matrix

  m = diag([mE, mE, mE, mE]);

end
