function mfs_pltelt(nofelt, elem);

# usage: mfs_pltelt(nofelt, elem)
#
# Input nofelt    Number of elements 
#       elem      Structure with element data
#
# The function plots 2-dimensional r2 elements.
#
# Description of the element structure:
#
#   elem.id                  Element identifier
#   elem.nodes(:)            Identifiers of element nodal points
#   elem.coor(:, 2)          Coordinates of element nodal points
#   elem.ects(:)             Element connectivity table
#   elem.mat                 Structure with element material data
#   elem.geom                Structure with element geometry data 
#
# ------------------------------------------------------------------------

  global pltparm;


# Plot elements

  coor = [elem.coor];
  line(coor(:, 1 : 2 : end), coor(:, 2 : 2 : end), 
       "color", pltparm.color);

# Plot element identifiers

  if (pltparm.eltid == 1)
     for nel = 1 : nofelt
         x = mean(elem(nel).coor(:, 1));
         y = mean(elem(nel).coor(:, 2));
         label = sprintf("%i", elem(nel).id);
         text(x, y, label, "fontsize", pltparm.fontsize);
     end
  end

end
