function mfs_prtelt(fid, nofelt, elem, lc, type)

# usage: mfs_prtelt(fid, nofelt, elem, lc, type)
#
# Input  fid       File handle
#        nofelt    Number of elements
#        elem(:)   Structure with element results
#        lc        Loadcase
#        type      Result type: 
#                  "stress"      Stresses
#                  "strain"      Strains
#                  "resultant"   Stress resultants
#                  "cstress"     Complex stresses
#                  "cstrain"     Complex strains
#                  "cresultant"  Complex stress resultants
#
# This function prints element results of 2-dimensional r2 elements.
#
# ------------------------------------------------------------------------

  switch type

  case "stress"
     mfs_prtstress_r2(fid, nofelt, elem, lc, 0);

  case "cstress"
     mfs_prtstress_r2(fid, nofelt, elem, lc, 1);

  case "strain"
     mfs_prtstrain_r2(fid, nofelt, elem, lc, 0);

  case "cstrain"
     mfs_prtstrain_r2(fid, nofelt, elem, lc, 1);

  case "resultant"
     mfs_prtresultant_r2(fid, nofelt, elem, lc, 0);

  case "cresultant"
     mfs_prtresultant_r2(fid, nofelt, elem, lc, 1);

  end

end
