function kE = mfs_ke(elem)

# usage: kE = mfs_ke(elem)
#
# Input  elem   Structure containing data of one element
#
# Output kE     Element stiffness matrix
#
# The function computes the stiffness matrix of a 2-dimensional linear
# triangular isoparametric membrane element with 3 nodes.
#
# ------------------------------------------------------------------------

# Material matrix

  E = mfs_emat2d(elem.mat);

# Strain-displacement transformation matrix

  [BE, JE] = mfs_BE_t3(elem.coor(:, 1), elem.coor(:, 2));

# Stiffness matrix

  kE = BE' * ((0.5 * elem.geom.t * JE) * E) * BE;

end
