function m = mfs_mle(elem)

# usage: m = mfs_mle(elem)
#
# Input  elem     Structure containing data of one element
#
# Output m        Element mass matrix
#
# The function computes the lumped mass matrix of a 2-dimensional
# triangular isoparametric membrane element with 3 nodes.
#
# -------------------------------------------------------------------

# Mass density

  if (isfield(elem.mat, "rho"))
     rho = elem.mat.rho;
  else
     m = sparse(6, 6);
     return;
  end

# Coordinates

  x  = elem.coor(:, 1);  y = elem.coor(:, 2);

# Area (divided by 3)

  A = ((x(2) - x(1)) * (y(3) - y(1)) - (x(3) - x(1)) * (y(2) - y(1))) / 6;

# Mass matrix

  m = rho * elem.geom.t * abs(A) * speye(6);

end
