function m = mfs_mle(elem)

# usage: m = mfs_mle(elem)
#
# Input  elem     Structure containing data of one element
#
# Output m        Element mass matrix
#
# The function computes the lumped mass matrix of a 2-dimensional
# triangular membrane element with 3 nodes and drilling dofs.
#
# -------------------------------------------------------------------

  persistent tdofs;

  if (isempty(tdofs))
     tdofs = [1, 2, 4, 5, 7, 8];
  end

# Mass density

  if (isfield(elem.mat, "rho"))
     rho = elem.mat.rho;
  else
     m = sparse(9, 9);
     return;
  end

# Coordinates

  x  = elem.coor(:, 1);  y = elem.coor(:, 2);

# Area (divided by 3)

  A = ((x(2) - x(1)) * (y(3) - y(1)) - (x(3) - x(1)) * (y(2) - y(1))) / 6;

# Mass matrix

  v        = zeros(9, 1, "double");
  v(tdofs) = rho * elem.geom.t * abs(A);
  m        = spdiags(v, 0, 9, 9);

end
