function eldata = mfs_defelt()

# usage: eldata = mfs_defelt()
#
# Output eldata   Structure with element type data:
#                   name     element name
#                   nelnod   number of element nodes
#                   ndofnod  number of dofs per node
#                   mat      indicates if material data are needed (0 or 1)
#                   geom     indicates if geometrical data are needed (0 or 1)
#                   gmshid   gmsh element type
#                   rtype    result type: 3 = plane stress
#                   axes     axes type:   0 = none
#
# The function returns the data of a 2-dimensional t6-element.
#
# -----------------------------------------------------------------------------

  eldata = struct("name", "t6",
                  "nelnod",  6,
                  "ndofnod", 2, 
                  "mat",     1,
                  "geom",    1,
                  "gmshid",  9,
                  "rtype",   3,
                  "axes",    0);

end
